/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_SERIAL_PORT_API_
#define SPICE3_SERIAL_PORT_API_

#include "rlTypes.h"

RL_C_API rlResult rlSerialPortInitConfig(rlSerialPortConfig* config);
RL_C_API rlResult rlSerialPortLoadConfig(rlHandle handle);
RL_C_API rlResult rlSerialPortStoreConfig(rlHandle handle);
RL_C_API rlResult rlSerialPortGetConfig(rlHandle handle, rlSerialPortConfig* config);
RL_C_API rlResult rlSerialPortSetConfig(rlHandle handle, const rlSerialPortConfig* config);

RL_C_API rlResult rlSerialPortTransmitString(rlHandle handle, const char* transmitMessage, uint32_t transmitMessageLength);
RL_C_API rlResult rlSerialPortTransmitLine(rlHandle handle, const char* transmitMessage, uint32_t transmitMessageLength);
RL_C_API rlResult rlSerialPortTransmitBytes(rlHandle handle, const uint8_t* transmitMessage, uint32_t transmitMessageLength);

RL_C_API rlResult rlSerialPortTryVerifyResponseString(
    rlHandle handle, const char* transmitMessage, uint32_t transmitMessageLength, const char* goodResponse, uint32_t goodResponseLength, uint32_t* successFlag);
RL_C_API rlResult rlSerialPortTryVerifyResponseLine(
    rlHandle handle, const char* transmitMessage, uint32_t transmitMessageLength, const char* goodResponse, uint32_t goodResponseLength, uint32_t* successFlag);
RL_C_API rlResult rlSerialPortTryVerifyResponseBytes(rlHandle handle, const uint8_t* transmitMessage, uint32_t transmitMessageLength,
    const uint8_t* goodResponse, uint32_t goodResponseLength, uint32_t* successFlag);

RL_C_API rlResult rlSerialPortReceiveString(rlHandle handle, uint32_t readCount, char* outBuffer, uint32_t bufferLen, uint32_t* outLen);
RL_C_API rlResult rlSerialPortReceiveLine(rlHandle handle, char* outBuffer, uint32_t bufferLen, uint32_t* outLen);
RL_C_API rlResult rlSerialPortReceiveBytes(rlHandle handle, uint32_t readCount, uint8_t* outBuffer, uint32_t bufferLen, uint32_t* outLen);

#endif // SPICE3_SERIAL_PORT_API_
